/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.provider.general;

import com.elitesland.cbpl.bpmn.convert.BpmnCfgConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnCommentDO;
import com.elitesland.cbpl.bpmn.provider.RoleApprovalProvider;
import com.elitesland.cbpl.bpmn.service.BpmnCommentService;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnInstStatus;
import com.elitesland.cbpl.bpmn.udc.BpmnOptType;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.yst.system.provider.SysUserRpcService;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class RoleApprGeneralProvider
implements RoleApprovalProvider {
    private static final Logger logger = LoggerFactory.getLogger(RoleApprGeneralProvider.class);
    private final BpmnInstanceService bpmnInstanceService;
    private final BpmnCommentService bpmnCommentService;
    @DubboReference
    private SysUserRpcService sysUserRpcService;

    @Override
    public BpmnResultRespVO startProcess(BpmnCfgRespVO bpmnCfgRespVO, String bizKey) {
        BpmnResultRespVO resultVO = BpmnCfgConvert.INSTANCE.cfgToResultVO(bpmnCfgRespVO);
        SysUserRpcDtoParam param = new SysUserRpcDtoParam();
        param.setRoleIds(resultVO.bizKeysToLong());
        List users = this.sysUserRpcService.findUserRpcDtoByParam(param);
        String userIds = users.stream().map(SysUserRpcDTO::getId).map(String::valueOf).collect(Collectors.joining(","));
        resultVO.setUserIds(userIds);
        resultVO.setRoleIds(resultVO.getInternalBizKey());
        resultVO.setBpmnStatus(BpmnInstStatus.APPROVING.getCode());
        Long bpmnInstId = this.bpmnInstanceService.insert(resultVO, bizKey);
        resultVO.setBpmnInstId(bpmnInstId);
        BpmnCommentDO bpmnCommentDO = new BpmnCommentDO();
        bpmnCommentDO.setBpmnInstId(resultVO.getBpmnInstId());
        bpmnCommentDO.setUserId(SecurityContextUtil.currentUserId() != null ? SecurityContextUtil.currentUserId() : 0L);
        bpmnCommentDO.setType(BpmnOptType.SUBMIT.getCode());
        bpmnCommentDO.setMessage(StringUtils.isNotEmpty((String)SecurityContextUtil.currentUserName()) ? SecurityContextUtil.currentUserName() : "admin\u521b\u5efa\u63d0\u4ea4");
        this.bpmnCommentService.insert(bpmnCommentDO);
        return resultVO;
    }

    @Override
    public BpmnResultRespVO agree(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO) {
        this.bpmnInstanceService.updateBpmnStatus(instanceVO.getId(), BpmnInstStatus.APPROVED.getCode());
        BpmnResultRespVO resultVO = BpmnCfgConvert.INSTANCE.cfgToResultVO(bpmnCfgRespVO);
        resultVO.setBpmnStatus(BpmnInstStatus.APPROVED.getCode());
        resultVO.setBpmnInstId(instanceVO.getId());
        BpmnCommentDO bpmnCommentDO = new BpmnCommentDO();
        bpmnCommentDO.setBpmnInstId(resultVO.getBpmnInstId());
        bpmnCommentDO.setUserId(SecurityContextUtil.currentUserId() != null ? SecurityContextUtil.currentUserId() : 0L);
        bpmnCommentDO.setType(BpmnOptType.AGREE.getCode());
        bpmnCommentDO.setMessage(StringUtils.isNotEmpty((String)SecurityContextUtil.currentUserName()) ? SecurityContextUtil.currentUserName() : "admin\u5ba1\u6279\u901a\u8fc7");
        this.bpmnCommentService.insert(bpmnCommentDO);
        return resultVO;
    }

    @Override
    public BpmnResultRespVO reject(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO) {
        this.bpmnInstanceService.updateBpmnStatus(instanceVO.getId(), BpmnInstStatus.REJECTED.getCode());
        BpmnResultRespVO resultVO = BpmnCfgConvert.INSTANCE.cfgToResultVO(bpmnCfgRespVO);
        resultVO.setBpmnStatus(BpmnInstStatus.REJECTED.getCode());
        resultVO.setBpmnInstId(instanceVO.getId());
        BpmnCommentDO bpmnCommentDO = new BpmnCommentDO();
        bpmnCommentDO.setBpmnInstId(resultVO.getBpmnInstId());
        bpmnCommentDO.setUserId(SecurityContextUtil.currentUserId() != null ? SecurityContextUtil.currentUserId() : 0L);
        bpmnCommentDO.setType(BpmnOptType.REJECT.getCode());
        bpmnCommentDO.setMessage(StringUtils.isNotEmpty((String)SecurityContextUtil.currentUserName()) ? SecurityContextUtil.currentUserName() : "admin\u5ba1\u6279\u62d2\u7edd");
        this.bpmnCommentService.insert(bpmnCommentDO);
        return resultVO;
    }

    public RoleApprGeneralProvider(BpmnInstanceService bpmnInstanceService, BpmnCommentService bpmnCommentService) {
        this.bpmnInstanceService = bpmnInstanceService;
        this.bpmnCommentService = bpmnCommentService;
    }
}

