/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.BpmnInstanceConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnInstanceDO;
import com.elitesland.cbpl.bpmn.repo.BpmnInstanceRepo;
import com.elitesland.cbpl.bpmn.repo.BpmnInstanceRepoProc;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BpmnInstanceServiceImpl
implements BpmnInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(BpmnInstanceServiceImpl.class);
    private final BpmnInstanceRepo bpmnInstanceRepo;
    private final BpmnInstanceRepoProc bpmnInstanceRepoProc;

    @Override
    public Long insert(BpmnResultRespVO resultVO, String bizKey) {
        BpmnInstanceDO instanceDO = BpmnInstanceConvert.INSTANCE.paramToDO(resultVO);
        instanceDO.setBizKey(bizKey);
        this.bpmnInstanceRepo.save(instanceDO);
        return instanceDO.getId();
    }

    @Override
    public BpmnInstanceDO bpmnInstanceById(Long bpmnInstId) {
        Optional bpmnInstanceDO = this.bpmnInstanceRepo.findById(bpmnInstId);
        if (bpmnInstanceDO.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u5b9e\u4f8b] " + bpmnInstId + " \u4e0d\u5b58\u5728");
        }
        return (BpmnInstanceDO)bpmnInstanceDO.get();
    }

    @Override
    public long updateBpmnStatus(long bpmnInstId, String bpmnStatus) {
        return this.bpmnInstanceRepoProc.updateBpmnStatus(bpmnInstId, bpmnStatus);
    }

    @Override
    public BpmnInstanceRespVO bpmnInstanceByModuleBizKey(BpmnModule moduleKey, String bizKey) {
        return this.bpmnInstanceRepoProc.bpmnInstanceByModuleBizKey(moduleKey, bizKey);
    }

    public BpmnInstanceServiceImpl(BpmnInstanceRepo bpmnInstanceRepo, BpmnInstanceRepoProc bpmnInstanceRepoProc) {
        this.bpmnInstanceRepo = bpmnInstanceRepo;
        this.bpmnInstanceRepoProc = bpmnInstanceRepoProc;
    }
}

