/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.BpmnCfgService;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba1\u6279\u914d\u7f6e"})
@ApiSupport(author="eric.hao", order=1)
@RestController
@RequestMapping(value={"/bpmn/config"}, produces={"application/json"})
public class BpmnCfgController {
    private static final Logger logger = LoggerFactory.getLogger(BpmnCfgController.class);
    private final BpmnCfgService bpmnCfgService;

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public ApiResult<PagingVO<BpmnCfgListRespVO>> list(@RequestBody BpmnCfgPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-BPMN]  page list, param={}", (Object)paramVO);
            return ApiResult.ok(this.bpmnCfgService.bpmnCfgPageBy(paramVO));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e - \u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public ApiResult<BpmnCfgRespVO> detail(@PathVariable(value="id") long id) {
        try {
            logger.debug("[CBPL-BPMN] query bpmnCfg by id={}", (Object)id);
            BpmnCfgRespVO bpmnCfgRespVO = this.bpmnCfgService.bpmnCfgById(id);
            return ApiResult.ok((Object)bpmnCfgRespVO);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e - \u4fdd\u5b58\u4fee\u6539")
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody BpmnCfgSaveParamVO saveParam) {
        try {
            logger.debug("[CBPL-BPMN] save bpmnCfg param = {}", (Object)saveParam);
            return ApiResult.ok((Object)this.bpmnCfgService.saveBpmnCfg(saveParam));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e - \u4fdd\u5b58\u4fee\u6539")
    @DeleteMapping(value={"/delete/{id}"})
    public ApiResult<Integer> save(@PathVariable(value="id") long id) {
        try {
            logger.debug("[CBPL-BPMN] delete bpmnCfg id = {}", (Object)id);
            return ApiResult.ok((Object)this.bpmnCfgService.deleteBpmnCfg(id));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public BpmnCfgController(BpmnCfgService bpmnCfgService) {
        this.bpmnCfgService = bpmnCfgService;
    }
}

