/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.BpmnService;
import com.elitesland.cbpl.bpmn.vo.param.BpmnParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba1\u6279\u64cd\u4f5c"})
@ApiSupport(author="eric.hao", order=2)
@RestController
@RequestMapping(value={"/bpmn/config"}, produces={"application/json"})
public class BpmnController {
    private static final Logger logger = LoggerFactory.getLogger(BpmnController.class);
    private final BpmnService bpmnService;

    @ApiOperation(value="\u5ba1\u6279\u64cd\u4f5c - \u901a\u8fc7")
    @PatchMapping(value={"/agree"})
    public ApiResult<BpmnResultRespVO> agree(BpmnParamVO paramVO) {
        try {
            logger.info("[CBPL-BPMN] approval agree, param={}", (Object)paramVO);
            BpmnResultRespVO resultVO = this.bpmnService.agree(paramVO);
            return ApiResult.ok((Object)resultVO);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u64cd\u4f5c - \u62d2\u7edd")
    @PatchMapping(value={"/reject"})
    public ApiResult<BpmnResultRespVO> reject(BpmnParamVO paramVO) {
        try {
            logger.info("[CBPL-BPMN] approval reject, param={}", (Object)paramVO);
            BpmnResultRespVO resultVO = this.bpmnService.reject(paramVO);
            return ApiResult.ok((Object)resultVO);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public BpmnController(BpmnService bpmnService) {
        this.bpmnService = bpmnService;
    }
}

