package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.BpmnCfgService;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Slf4j
@Api(tags = "审批配置")
@ApiSupport(author = "eric.hao", order = 1)
@RestController
@RequestMapping(value = "/bpmn/config", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class BpmnCfgController {

    private final BpmnCfgService bpmnCfgService;

    @ApiOperation(value = "审批配置 - 分页查询")
    @PostMapping(value = "/list")
    public ApiResult<PagingVO<BpmnCfgListRespVO>> list(@RequestBody BpmnCfgPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-BPMN]  page list, param={}", paramVO);
            return ApiResult.ok(bpmnCfgService.bpmnCfgPageBy(paramVO));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "审批配置 - 明细查询")
    @GetMapping("/detail/{id}")
    public ApiResult<BpmnCfgRespVO> detail(@PathVariable("id") long id) {
        try {
            logger.debug("[CBPL-BPMN] query bpmnCfg by id={}", id);
            BpmnCfgRespVO bpmnCfgRespVO = bpmnCfgService.bpmnCfgById(id);
            return ApiResult.ok(bpmnCfgRespVO);
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "审批配置 - 保存修改")
    @PostMapping("/save")
    public ApiResult<Long> save(@RequestBody BpmnCfgSaveParamVO saveParam) {
        try {
            logger.debug("[CBPL-BPMN] save bpmnCfg param = {}", saveParam);
            return ApiResult.ok(bpmnCfgService.saveBpmnCfg(saveParam));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "审批配置 - 保存修改")
    @DeleteMapping("/delete/{id}")
    public ApiResult<Integer> save(@PathVariable("id") long id) {
        try {
            logger.debug("[CBPL-BPMN] delete bpmnCfg id = {}", id);
            return ApiResult.ok(bpmnCfgService.deleteBpmnCfg(id));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

}
