package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.BpmnCommonService;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCommonRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author yc
 * @since 2022/09/15
 */
@Slf4j
@Api(tags = "通用接口（下拉之类）")
@ApiSupport(author = "yc", order = 2)
@RestController
@RequestMapping(value = "/bpmn/common", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class BpmnCommonController {

    private final BpmnCommonService commonService;

    @ApiOperation(value = "枚举查询")
    @GetMapping("/query/{type}")
    public ApiResult<List<BpmnCommonRespVO>> query(@PathVariable("type") String type) {
        try {
            logger.info("[CBPL-BPMN] query common udc, param={}", type);
            return ApiResult.ok(commonService.queryCommonUdc(type));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

}
