package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.BpmnService;
import com.elitesland.cbpl.bpmn.vo.param.BpmnParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2022/06/01
 */
@Slf4j
@Api(tags = "审批操作")
@ApiSupport(author = "eric.hao", order = 2)
@RestController
@RequestMapping(value = "/bpmn/config", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class BpmnController {

    private final BpmnService bpmnService;

    @ApiOperation(value = "审批操作 - 通过")
    @PatchMapping("/agree")
    public ApiResult<BpmnResultRespVO> agree(BpmnParamVO paramVO) {
        try {
            logger.info("[CBPL-BPMN] approval agree, param={}", paramVO);
            BpmnResultRespVO resultVO = bpmnService.agree(paramVO);
            return ApiResult.ok(resultVO);
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "审批操作 - 拒绝")
    @PatchMapping("/reject")
    public ApiResult<BpmnResultRespVO> reject(BpmnParamVO paramVO) {
        try {
            logger.info("[CBPL-BPMN] approval reject, param={}", paramVO);
            BpmnResultRespVO resultVO = bpmnService.reject(paramVO);
            return ApiResult.ok(resultVO);
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }
}
