package com.elitesland.cbpl.bpmn.convert;

import com.elitesland.cbpl.bpmn.entity.BpmnCfgDO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.common.BaseMapperConfig;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @author eric.hao
 * @since 2022/05/25
 */
@Mapper(config = BaseMapperConfig.class)
public interface BpmnCfgConvert {

    BpmnCfgConvert INSTANCE = Mappers.getMapper(BpmnCfgConvert.class);

    BpmnCfgRespVO doToVO(BpmnCfgDO bpmnCfgDO);

    BpmnResultRespVO cfgToResultVO(BpmnCfgRespVO bpmnCfgRespVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(BpmnCfgSaveParamVO saveParam, @MappingTarget BpmnCfgDO cfgDO);

    BpmnCfgDO saveParamToDo(BpmnCfgSaveParamVO saveParam);
}
