package com.elitesland.cbpl.bpmn.entity;

import com.elitesland.yst.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Entity
@Table(name = "cbpl_bpmn_config")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_bpmn_config", comment = "审批配置")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_bpmn_config", description = "审批配置")
public class BpmnCfgDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -7663585131451710925L;

    @Comment(value = "业务模块")
    @Column()
    private String moduleKey;

    @Comment(value = "是否审批(0不需要审批；1需要审批；)")
    @Column()
    private Integer bpmnEnable;

    @Comment(value = "审批环境：INTERNAL当前系统；EXTERNAL外部系统；")
    @Column()
    private String bpmnEnv;

    @Comment(value = "外部系统：JDE、SAP、QDA、OA、SRM等")
    @Column()
    private String external;

    @Comment(value = "内部系统：自动审核、指定角色、指定人员、工作流等")
    @Column()
    private String internal;

    /**
     * 自动审核 => 敏感词库表id
     * 指定角色 => 角色编码
     * 指定人员 => 用户表id
     * 工作流 => 流程定义编码
     */
    @Comment(value = "内部系统类型时，对应的业务主键")
    @Column()
    private String internalBizKey;
}
