package com.elitesland.cbpl.bpmn.entity;

import com.elitesland.yst.common.annotation.Comment;
import com.elitesland.yst.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
@Entity
@Table(name = "cbpl_bpmn_comment")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_bpmn_comment", comment = "审批实例履历")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_bpmn_comment", description = "审批实例履历")
public class BpmnCommentDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -7557297047695956015L;

    @Comment(value = "审批实例表id")
    @Column()
    private Long bpmnInstId;

    @Comment(value = "用户id")
    @Column()
    private Long userId;

    @Comment(value = "审批类型")
    @Column()
    private String type;

    @Comment(value = "审批意见")
    @Column()
    private String message;
}
