package com.elitesland.cbpl.bpmn.entity;

import com.elitesland.yst.common.annotation.Comment;
import com.elitesland.yst.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Entity
@Table(name = "cbpl_bpmn_instance")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_bpmn_instance", comment = "审批实例")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_bpmn_instance", description = "审批实例")
public class BpmnInstanceDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -7663585131451710925L;

    @Comment(value = "业务模块")
    @Column()
    private String moduleKey;

    @Comment(value = "业务主键")
    @Column()
    private String bizKey;

    @Comment(value = "代办人角色")
    @Column()
    private String roleIds;

    @Comment(value = "代办人")
    @Column()
    private String userIds;

    @Comment(value = "审批方式")
    @Column()
    private String bpmnMethod;

    @Comment(value = "审批状态")
    @Column()
    private String bpmnStatus;

    @Comment(value = "流程实例id")
    @Column()
    private String procInstId;
}
