package com.elitesland.cbpl.bpmn.provider;

import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;

/**
 * 指定角色审批
 *
 * @author eric.hao
 * @since 2022/05/30
 */
@Unicom
public interface RoleApprovalProvider {

    /**
     * 审批 - 启动
     *
     * @param bpmnCfgRespVO 审批配置项
     * @param bizKey        业务主键
     * @return 审批结果
     */
    BpmnResultRespVO startProcess(BpmnCfgRespVO bpmnCfgRespVO, String bizKey);

    /**
     * 审批 - 同意
     *
     * @param bpmnCfgRespVO 审批配置项
     * @param instanceVO    审批实例
     * @return 审批结果
     */
    BpmnResultRespVO agree(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO);

    /**
     * 审批 - 驳回
     *
     * @param bpmnCfgRespVO 审批配置项
     * @param instanceVO    审批实例
     * @return 审批结果
     */
    BpmnResultRespVO reject(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO);
}
