package com.elitesland.cbpl.bpmn.provider.general;

import com.elitesland.cbpl.bpmn.convert.BpmnCfgConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnCommentDO;
import com.elitesland.cbpl.bpmn.provider.LexiconApprovalProvider;
import com.elitesland.cbpl.bpmn.service.BpmnCommentService;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnInstStatus;
import com.elitesland.cbpl.bpmn.udc.BpmnOptType;
import com.elitesland.cbpl.bpmn.util.SensitiveWordUtils;
import com.elitesland.cbpl.bpmn.vo.param.SensitiveWordParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class LexiconApprGeneralProvider implements LexiconApprovalProvider {

    private static final String AUTO_USER = "SYSTEM";
    private static final String AUTO_ROLE = "SYSTEM";

    private final BpmnInstanceService bpmnInstanceService;
    private final BpmnCommentService bpmnCommentService;
    private final SensitiveWordUtils sensitiveWordUtils;

    /**
     * @param bpmnCfgRespVO 审批配置项
     * @param bizKey        业务主键
     * @param wordParamVO   自动审批敏感词相关校验
     * @return
     */
    @Override
    public BpmnResultRespVO startProcess(BpmnCfgRespVO bpmnCfgRespVO, String bizKey, SensitiveWordParamVO wordParamVO) {
        boolean containsFlag = sensitiveWordUtils.isContainsSensitiveWord(wordParamVO);
        BpmnResultRespVO resultVO = BpmnCfgConvert.INSTANCE.cfgToResultVO(bpmnCfgRespVO);
        if(containsFlag){
            Set<String> sensitiveWord = sensitiveWordUtils.getSensitiveWord(wordParamVO);
            resultVO.setSensitiveWords(sensitiveWord);
        }
        resultVO.setUserIds(AUTO_USER); // 代办人
        resultVO.setRoleIds(AUTO_ROLE); // 代办人角色
        resultVO.setBpmnStatus(!containsFlag ? BpmnInstStatus.APPROVED.getCode() : BpmnInstStatus.REJECTED.getCode());
        Long bpmnInstId = bpmnInstanceService.insert(resultVO, bizKey);
        resultVO.setBpmnInstId(bpmnInstId);
        BpmnCommentDO bpmnCommentDO = new BpmnCommentDO();
        bpmnCommentDO.setBpmnInstId(resultVO.getBpmnInstId());
        bpmnCommentDO.setUserId(SecurityContextUtil.currentUserId() != null ? SecurityContextUtil.currentUserId() : 0L);
        bpmnCommentDO.setType(!containsFlag ? BpmnOptType.AGREE.getCode() : BpmnOptType.REJECT.getCode());
        bpmnCommentDO.setMessage(StringUtils.isNotEmpty(SecurityContextUtil.currentUserName()) ? SecurityContextUtil.currentUserName() : "admin" + "系统自动审批完成");
        bpmnCommentService.insert(bpmnCommentDO);
        return resultVO;
    }
}
