package com.elitesland.cbpl.bpmn.provider.general;

import com.elitesland.cbpl.bpmn.provider.UserApprovalProvider;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class UserApprGeneralProvider implements UserApprovalProvider {

    @Override
    public BpmnResultRespVO startProcess(BpmnCfgRespVO bpmnCfgRespVO, String bizKey) {
        throw new BusinessException("暂不支持指定人员审批 敬请期待");
    }

    @Override
    public BpmnResultRespVO agree(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO) {
        throw new BusinessException("暂不支持指定人员该操作 请联系管理员");
    }

    @Override
    public BpmnResultRespVO reject(BpmnCfgRespVO bpmnCfgRespVO, BpmnInstanceRespVO instanceVO) {
        throw new BusinessException("暂不支持指定人员该操作 请联系管理员");
    }
}
