package com.elitesland.cbpl.bpmn.repo;

import com.elitesland.cbpl.bpmn.entity.BpmnCfgDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
public interface BpmnCfgRepo extends JpaRepository<BpmnCfgDO, Long>, QuerydslPredicateExecutor<BpmnCfgDO> {

    Optional<BpmnCfgDO> findByModuleKey(String module);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update cbpl_bpmn_config set delete_flag = ?2 where id = ?1", nativeQuery = true)
    Integer updateDeleteFlag(Long id, Integer deleteFlag);
}
