package com.elitesland.cbpl.bpmn.repo;

import com.elitesland.cbpl.bpmn.entity.QBpmnCfgDO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@Component
@RequiredArgsConstructor
public class BpmnCfgRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBpmnCfgDO Q_BPMN_CFG_DO = QBpmnCfgDO.bpmnCfgDO;

    private final QBean<BpmnCfgListRespVO> bpmnCfgListVO = Projections.bean(
            BpmnCfgListRespVO.class,
            Q_BPMN_CFG_DO.id,
            Q_BPMN_CFG_DO.moduleKey,
            Q_BPMN_CFG_DO.bpmnEnable,
            Q_BPMN_CFG_DO.bpmnEnv,
            Q_BPMN_CFG_DO.external,
            Q_BPMN_CFG_DO.internal,
            Q_BPMN_CFG_DO.internalBizKey
    );

    private Predicate where(BpmnCfgPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_BPMN_CFG_DO.deleteFlag.eq(0));
        // 业务模块
        if (StringUtils.isNotBlank(paramVO.getModuleKey())) {
            predicates.add(Q_BPMN_CFG_DO.moduleKey.eq(paramVO.getModuleKey()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long bpmnCfgCountBy(BpmnCfgPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Q_BPMN_CFG_DO.count())
                .from(Q_BPMN_CFG_DO);
        jpaQuery.where(this.where(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<BpmnCfgListRespVO> bpmnCfgPageBy(BpmnCfgPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(bpmnCfgListVO)
                .from(Q_BPMN_CFG_DO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, Q_BPMN_CFG_DO);
        jpaQuery.where(this.where(paramVO));
        return jpaQuery.fetch();
    }
}
