package com.elitesland.cbpl.bpmn.repo;

import com.elitesland.cbpl.bpmn.entity.QBpmnInstanceDO;
import com.elitesland.cbpl.bpmn.udc.BpmnInstStatus;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
@Component
@RequiredArgsConstructor
public class BpmnInstanceRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBpmnInstanceDO Q_BPMN_INSTANCE_DO = QBpmnInstanceDO.bpmnInstanceDO;

    public long updateBpmnStatus(long bpmnInstId, String bpmnStatus) {
        Predicate predicate = Q_BPMN_INSTANCE_DO.id.eq(bpmnInstId);
        JPAUpdateClause update = jpaQueryFactory.update(Q_BPMN_INSTANCE_DO)
                .set(Q_BPMN_INSTANCE_DO.bpmnStatus, bpmnStatus)
                .where(predicate);
        return update.execute();
    }

    public BpmnInstanceRespVO bpmnInstanceByModuleBizKey(BpmnModule moduleKey, String bizKey) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        BpmnInstanceRespVO.class,
                        Q_BPMN_INSTANCE_DO.id,
                        Q_BPMN_INSTANCE_DO.moduleKey,
                        Q_BPMN_INSTANCE_DO.bizKey,
                        Q_BPMN_INSTANCE_DO.roleIds,
                        Q_BPMN_INSTANCE_DO.userIds,
                        Q_BPMN_INSTANCE_DO.bpmnMethod,
                        Q_BPMN_INSTANCE_DO.bpmnStatus,
                        Q_BPMN_INSTANCE_DO.procInstId
                ))
                .from(Q_BPMN_INSTANCE_DO);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_BPMN_INSTANCE_DO.deleteFlag.eq(0));
        predicates.add(Q_BPMN_INSTANCE_DO.moduleKey.eq(moduleKey.getCode()));
        predicates.add(Q_BPMN_INSTANCE_DO.bizKey.eq(bizKey));
        predicates.add(Q_BPMN_INSTANCE_DO.bpmnStatus.ne(BpmnInstStatus.APPROVED.getCode()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchOne();
    }
}
