package com.elitesland.cbpl.bpmn.service;

import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.yst.common.base.PagingVO;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
public interface BpmnCfgService {

    /**
     * 审批配置 - 分页查询
     *
     * @param paramVO 分页参数
     * @return 分页列表
     */
    PagingVO<BpmnCfgListRespVO> bpmnCfgPageBy(BpmnCfgPageParamVO paramVO);

    /**
     * 审批配置 - 明细查询
     *
     * @param bpmnCfgId 明细id
     * @return 明细信息
     */
    BpmnCfgRespVO bpmnCfgById(long bpmnCfgId);

    /**
     * 审批配置 - 明细查询
     *
     * @param moduleKey 业务模块
     * @return 明细信息
     */
    BpmnCfgRespVO bpmnCfgByModule(String moduleKey);

    /**
     * 审批配置 - 保存
     * @param saveParam
     * @return
     */
    Long saveBpmnCfg(BpmnCfgSaveParamVO saveParam);

    /**
     * 审批配置 - 删除
     * @param id
     * @return
     */
    Integer deleteBpmnCfg(long id);
}
