package com.elitesland.cbpl.bpmn.service;

import com.elitesland.cbpl.bpmn.entity.BpmnInstanceDO;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
public interface BpmnInstanceService {

    /**
     * 审批实例 - 新增
     *
     * @param resultVO 审批结果
     * @param bizKey   业务主键
     * @return 审批实例id
     */
    Long insert(BpmnResultRespVO resultVO, String bizKey);

    /**
     * 审批实例 - 明细查询
     *
     * @param bpmnInstId 审批实例id
     * @return 明细信息
     */
    BpmnInstanceDO bpmnInstanceById(Long bpmnInstId);

    /**
     * 审批实例 - 修改审批状态
     *
     * @param bpmnInstId 审批实例id
     * @param bpmnStatus 审批状态
     * @return 生效行数
     */
    long updateBpmnStatus(long bpmnInstId, String bpmnStatus);

    /**
     * 审批实例 - 查询
     *
     * @param moduleKey 业务模块
     * @param bizKey    业务主键
     * @return 审批实例
     */
    BpmnInstanceRespVO bpmnInstanceByModuleBizKey(BpmnModule moduleKey, String bizKey);
}
