package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.config.BpmnUdcConfig;
import com.elitesland.cbpl.bpmn.service.BpmnCommonService;
import com.elitesland.cbpl.bpmn.udc.*;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCommonRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author yc
 * @since 2022/09/15
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BpmnCommonServiceImpl implements BpmnCommonService {

    private final BpmnUdcConfig udcConfig;

    @Override
    public List<BpmnCommonRespVO> queryCommonUdc(String type) {
        List<BpmnCommonRespVO> respVOList = new ArrayList<>();
        if(StringUtils.isNotEmpty(type)){
            switch (type){
                case "env":
                    BpmnEnv[] envs = BpmnEnv.values();
                    Stream.of(envs).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    excludeConfig(udcConfig.getEnv(), respVOList);
                    break;
                case "external":
                    BpmnExternal[] externals = BpmnExternal.values();
                    Stream.of(externals).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    excludeConfig(udcConfig.getExternal(), respVOList);
                    break;
                case "internal":
                    BpmnInternal[] internals = BpmnInternal.values();
                    Stream.of(internals).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    excludeConfig(udcConfig.getInternal(), respVOList);
                    break;
                case "enable":
                    BpmnEnable[] enables = BpmnEnable.values();
                    Stream.of(enables).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode().toString(), env.getDesc())));
                    break;
                case "module":
                    BpmnModule[] modules = BpmnModule.values();
                    Stream.of(modules).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    break;
                default:
                    break;
            }
        }
        return respVOList;
    }

    /**
     * 过滤不可用配置项
     * @param envExclude
     * @param respVOList
     */
    private void excludeConfig(String envExclude, List<BpmnCommonRespVO> respVOList) {
        if(StringUtils.isNotEmpty(envExclude)){
            List<String> split = Arrays.asList(envExclude.split(","));
            respVOList.removeAll(respVOList.stream().filter(resp -> split.contains(resp.getCode())).collect(Collectors.toList()));
        }
    }
}
