package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.BpmnInstanceConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnInstanceDO;
import com.elitesland.cbpl.bpmn.repo.BpmnInstanceRepo;
import com.elitesland.cbpl.bpmn.repo.BpmnInstanceRepoProc;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.yst.common.exception.BusinessException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
@Slf4j
@Service
@AllArgsConstructor
public class BpmnInstanceServiceImpl implements BpmnInstanceService {

    private final BpmnInstanceRepo bpmnInstanceRepo;
    private final BpmnInstanceRepoProc bpmnInstanceRepoProc;

    @Override
    public Long insert(BpmnResultRespVO resultVO, String bizKey) {
        BpmnInstanceDO instanceDO = BpmnInstanceConvert.INSTANCE.paramToDO(resultVO);
        instanceDO.setBizKey(bizKey);
        bpmnInstanceRepo.save(instanceDO);
        return instanceDO.getId();
    }

    @Override
    public BpmnInstanceDO bpmnInstanceById(Long bpmnInstId) {
        Optional<BpmnInstanceDO> bpmnInstanceDO = bpmnInstanceRepo.findById(bpmnInstId);
        if (bpmnInstanceDO.isEmpty()) {
            throw new BusinessException("[审批实例] " + bpmnInstId + " 不存在");
        }
        return bpmnInstanceDO.get();
    }

    @Override
    public long updateBpmnStatus(long bpmnInstId, String bpmnStatus) {
        return bpmnInstanceRepoProc.updateBpmnStatus(bpmnInstId, bpmnStatus);
    }

    @Override
    public BpmnInstanceRespVO bpmnInstanceByModuleBizKey(BpmnModule moduleKey, String bizKey) {
        return bpmnInstanceRepoProc.bpmnInstanceByModuleBizKey(moduleKey, bizKey);
    }
}
