package com.elitesland.cbpl.bpmn.udc;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
public enum BpmnEnv {

    INTERNAL("当前系统"),
    EXTERNAL("外部系统"),
    ;

    public String getCode() {
        return this.name();
    }

    @Getter
    private final String desc;

    BpmnEnv(String desc) {
        this.desc = desc;
    }

    public static BpmnEnv fromCode(String code) {
        for (BpmnEnv e : BpmnEnv.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return INTERNAL;
    }
}
