package com.elitesland.cbpl.bpmn.udc;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
public enum BpmnExternal {

    JDE("JDE"),
    SAP("SAP"),
    QDA("QDA"),
    OA("OA"),
    SRM("SRM"),
    B2B("B2B"),
    ;

    public String getCode() {
        return this.name();
    }

    @Getter
    private final String desc;

    BpmnExternal(String desc) {
        this.desc = desc;
    }

    public static BpmnExternal fromCode(String code) {
        for (BpmnExternal e : BpmnExternal.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static String descBy(String code) {
        for (BpmnExternal e : BpmnExternal.values()) {
            if (e.getCode().equals(code)) {
                return e.getDesc();
            }
        }
        return null;
    }
}
