package com.elitesland.cbpl.bpmn.udc;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
public enum BpmnInternal {

    AUTO("自动审核"),
    ASSIGN_ROLE("指定角色"),
    ASSIGN_USER("指定人员"),
    WORKFLOW("工作流"),
    ;

    public String getCode() {
        return this.name();
    }

    @Getter
    private final String desc;

    BpmnInternal(String desc) {
        this.desc = desc;
    }

    public static BpmnInternal fromCode(String code) {
        for (BpmnInternal e : BpmnInternal.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static String descBy(String code) {
        for (BpmnInternal e : BpmnInternal.values()) {
            if (e.getCode().equals(code)) {
                return e.getDesc();
            }
        }
        return null;
    }
}
