package com.elitesland.cbpl.bpmn.udc;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
public enum BpmnOptType {

    SUBMIT("1", "启动"),
    AGREE("2", "同意"),
    REJECT("3", "拒绝"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    BpmnOptType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String descBy(String code) {
        for (BpmnOptType e : BpmnOptType.values()) {
            if (e.getCode().equals(code)) {
                return e.getDesc();
            }
        }
        return null;
    }
}
