package com.elitesland.cbpl.bpmn.util;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitesland.cbpl.bpmn.vo.param.SensitiveWordParamVO;
import com.elitesland.yst.common.util.RedisUtils;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
@RequiredArgsConstructor
public class SensitiveWordUtils {

    private static final String sensitiveRedisKeyPrefix = "sensitiveWord";
    private static final String defaultSensitiveRedisKeySuffix = "ALL";
    private static final String SPECIAL_CHARACTER = "[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，·、？]";
    private Map<String, String> sensitiveWordMap = new HashMap<>();
    public static int minMatchTYpe = 1;      //最小匹配规则

    private final RedisUtils redisClient;

    public boolean isContainsSensitiveWord(SensitiveWordParamVO wordParamVO) {
        boolean flag = false;
        if(wordParamVO != null){
            // 1. 取敏感词组成map集合
            List<String> values = getSensitiveWordList(wordParamVO);
            if (CollectionUtils.isNotEmpty(values)) {
                addSensitiveWordToHashMap(values);
            }
            // 2. 过滤敏感词
            if(CollectionUtils.isNotEmpty(wordParamVO.getWordList())){
                List<String> wordList = wordParamVO.getWordList();
                int matchType = wordParamVO.getMatchType() != null ? wordParamVO.getMatchType() : minMatchTYpe;
                boolean scFilter = wordParamVO.getScFilter() == null || wordParamVO.getScFilter();
                for (int count = 0; count < wordList.size(); count++) {
                    String txt = scFilter ? wordList.get(count).replaceAll(SPECIAL_CHARACTER, "") : wordList.get(count);
                    for (int i = 0; i < txt.length(); i++) {
                        int matchFlag = checkSensitiveWord(txt, i, matchType); // 判断是否包含敏感字符
                        if (matchFlag > 0) { // 大于0存在，返回true
                            flag = true;
                        }
                    }
                }
            }
        }
        return flag;
    }

    private List<String> getSensitiveWordList(SensitiveWordParamVO wordParamVO) {
        Set<Object> defaultList = redisClient.sGet(sensitiveRedisKeyPrefix + "_" + defaultSensitiveRedisKeySuffix);
        if(StringUtils.isNotEmpty(wordParamVO.getWordType()) && !defaultSensitiveRedisKeySuffix.equals(wordParamVO.getWordType())){
            defaultList.addAll(redisClient.sGet(sensitiveRedisKeyPrefix + "_" + wordParamVO.getWordType()));
        }
        List<String> result = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(defaultList)){
            defaultList.forEach(word -> result.add(String.valueOf(word)));
        }
        return result;
    }

    /**
     * 校验是否存在敏感词
     *
     * @param txt
     * @param beginIndex
     * @param matchType
     * @return
     */
    public int checkSensitiveWord(String txt, int beginIndex, int matchType) {
        boolean flag = false;    //敏感词结束标识位：用于敏感词只有1位的情况
        int matchFlag = 0;     //匹配标识数默认为0
        char word = 0;
        Map nowMap = sensitiveWordMap;
        for (int i = beginIndex; i < txt.length(); i++) {
            word = txt.charAt(i);
            nowMap = (Map) nowMap.get(word);     //获取指定key
            if (nowMap != null) {     //存在，则判断是否为最后一个
                matchFlag++;     //找到相应key，匹配标识+1
                if ("1".equals(nowMap.get("isEnd"))) {       //如果为最后一个匹配规则,结束循环，返回匹配标识数
                    flag = true;       //结束标志位为true
                    if (minMatchTYpe == matchType) {    //最小规则，直接返回,最大规则还需继续查找
                        break;
                    }
                }
            } else {     //不存在，直接返回
                break;
            }
        }
        if (!flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    /**
     * 初始化敏感词库
     *
     * @param sensitiveWordList
     */
    public void addSensitiveWordToHashMap(List<String> sensitiveWordList) {
        sensitiveWordMap = new HashMap(sensitiveWordList.size());     //初始化敏感词容器，减少扩容操作
        String key = null;
        Map nowMap = null;
        Map<String, String> newWorMap = null;
        //迭代keyWordSet
        Iterator<String> iterator = sensitiveWordList.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();    //关键字
            nowMap = sensitiveWordMap;
            for (int i = 0; i < key.length(); i++) {
                char keyChar = key.charAt(i);       //转换成char型
                Object wordMap = nowMap.get(keyChar);       //获取
                if (wordMap != null) {        //如果存在该key，直接赋值
                    nowMap = (Map) wordMap;
                } else {     //不存在则，则构建一个map，同时将isEnd设置为0，因为他不是最后一个
                    newWorMap = new HashMap<String, String>();
                    newWorMap.put("isEnd", "0");     //不是最后一个
                    nowMap.put(keyChar, newWorMap);
                    nowMap = newWorMap;
                }
                if (i == key.length() - 1) {
                    nowMap.put("isEnd", "1");    //最后一个
                }
            }
        }
    }

    /**
     * Object 对象转 List
     */
    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        List<T> result = new ArrayList<T>();
        if (obj instanceof List<?>) {
            for (Object o : (List<?>) obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }


    public Set<String> getSensitiveWord(SensitiveWordParamVO wordParamVO) {
        Set<String> sensitiveWordList = new HashSet<String>();
        List<String> wordList = wordParamVO.getWordList();
        int matchType = wordParamVO.getMatchType() != null ? wordParamVO.getMatchType() : minMatchTYpe;
        for (int count = 0; count < wordList.size(); count++) {
            boolean scFilter = wordParamVO.getScFilter() == null || wordParamVO.getScFilter();
            String txt = scFilter ? wordList.get(count).replaceAll(SPECIAL_CHARACTER, "") : wordList.get(count);
            for (int i = 0; i < txt.length(); i++) {
                int length = checkSensitiveWord(txt, i, matchType); // 判断是否包含敏感字符
                if (length > 0) { // 存在,加入list中
                    sensitiveWordList.add(txt.substring(i, i + length));
                    i = i + length - 1; // 减1的原因，是因为for会自增
                }
            }
        }
        return sensitiveWordList;
    }
}
