package com.elitesland.cbpl.bpmn.vo.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * @author yc
 * @since 2022/09/15
 */
@ApiModel(description = "审批配置保存参数")
@Data
@ToString(callSuper = true)
public class BpmnCfgSaveParamVO {

    @ApiModelProperty("日志id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "业务模块")
    private String moduleKey;

    @ApiModelProperty(value = "是否审批(0不需要审批；1需要审批；)")
    private Integer bpmnEnable;

    @ApiModelProperty(value = "审批环境：INTERNAL当前系统；EXTERNAL外部系统；")
    private String bpmnEnv;

    @ApiModelProperty(value = "外部系统：JDE、SAP、QDA、OA、SRM等")
    private String external;

    @ApiModelProperty(value = "内部系统：自动审核、指定角色、指定人员、工作流等")
    private String internal;

    /**
     * 自动审核 => 敏感词库表id
     * 指定角色 => 角色编码
     * 指定人员 => 用户表id
     * 工作流 => 流程定义编码
     */
    @ApiModelProperty(value = "内部系统类型时，对应的业务主键")
    private String internalBizKey;

}
