package com.elitesland.cbpl.bpmn.vo.resp;

import com.elitesland.cbpl.bpmn.udc.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@ApiModel(description = "审批配置分页列表")
@Data
public class BpmnCfgListRespVO implements Serializable {

    @Serial
    private static final long serialVersionUID = -776111942541618182L;

    @ApiModelProperty(value = "配置id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * {@link BpmnModule}
     */
    @ApiModelProperty(value = "业务模块")
    private String moduleKey;
    private String moduleKeyName;

    /**
     * {@link BpmnEnable}
     */
    @ApiModelProperty(value = "是否审批(0不需要审批；1需要审批；)")
    private Integer bpmnEnable;
    private String bpmnEnableName;

    /**
     * {@link BpmnEnv}
     */
    @ApiModelProperty(value = "审批环境：INTERNAL当前系统；EXTERNAL外部系统；")
    private String bpmnEnv;
    private String bpmnEnvName;

    /**
     * {@link BpmnExternal}
     */
    @ApiModelProperty(value = "外部系统：JDE、SAP、QDA、OA、SRM等")
    private String external;
    private String externalName;

    /**
     * {@link BpmnInternal}
     */
    @ApiModelProperty(value = "内部系统：自动审核、指定角色、指定人员、工作流等")
    private String internal;
    private String internalName;

    @ApiModelProperty(value = "内部系统类型时，对应的业务主键")
    private String internalBizKey;
}
