package com.elitesland.cbpl.bpmn.vo.resp;

import com.elitesland.cbpl.bpmn.udc.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Optional;

import static com.elitesland.cbpl.bpmn.udc.BpmnEnable.BPMN_ENABLE;
import static com.elitesland.cbpl.bpmn.udc.BpmnEnv.EXTERNAL;
import static com.elitesland.cbpl.bpmn.udc.BpmnEnv.INTERNAL;

/**
 * @author eric.hao
 * @since 2022/05/30
 */
@ApiModel(description = "审批配置")
@Data
public class BpmnCfgRespVO {

    @ApiModelProperty(value = "配置id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * {@link BpmnModule}
     */
    @ApiModelProperty(value = "业务模块")
    private String moduleKey;

    /**
     * {@link BpmnEnable}
     */
    @ApiModelProperty(value = "是否审批(0不需要审批；1需要审批；)")
    private Integer bpmnEnable;

    @JsonProperty
    public boolean isEnabled() {
        return Optional.ofNullable(bpmnEnable).stream().allMatch(row -> row.compareTo(BPMN_ENABLE.getCode()) == 0);
    }

    /**
     * {@link BpmnEnv}
     */
    @ApiModelProperty(value = "审批环境：INTERNAL当前系统；EXTERNAL外部系统；")
    private String bpmnEnv;

    @JsonProperty
    public boolean isExternal() {
        return Optional.ofNullable(bpmnEnv).stream().allMatch(row -> row.compareTo(EXTERNAL.getCode()) == 0);
    }

    @JsonProperty
    public boolean isInternal() {
        return Optional.ofNullable(bpmnEnv).stream().allMatch(row -> row.compareTo(INTERNAL.getCode()) == 0);
    }

    /**
     * {@link BpmnExternal}
     */
    @ApiModelProperty(value = "外部系统：JDE、SAP、QDA、OA、SRM等")
    private String external;

    public BpmnExternal fromExternal() {
        return BpmnExternal.fromCode(external);
    }

    /**
     * {@link BpmnInternal}
     */
    @ApiModelProperty(value = "内部系统：自动审核、指定角色、指定人员、工作流等")
    private String internal;

    public BpmnInternal fromInternal() {
        return BpmnInternal.fromCode(internal);
    }

    @ApiModelProperty(value = "内部系统类型时，对应的业务主键")
    private String internalBizKey;
}
