package com.elitesland.cbpl.bpmn.vo.resp;

import com.elitesland.cbpl.bpmn.udc.BpmnEnv;
import com.elitesland.cbpl.bpmn.udc.BpmnExternal;
import com.elitesland.cbpl.bpmn.udc.BpmnInternal;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2022/05/31
 */
@ApiModel(description = "审批结果")
@Data
public class BpmnResultRespVO extends BpmnCfgRespVO {

    @ApiModelProperty(value = "审批实例表id")
    private Long bpmnInstId;

    @ApiModelProperty(value = "审批方式")
    @JsonProperty
    public String getBpmnMethod() {
        return switch (BpmnEnv.fromCode(super.getBpmnEnv())) {
            case EXTERNAL -> BpmnExternal.descBy(super.getExternal());
            case INTERNAL -> BpmnInternal.descBy(super.getInternal());
        };
    }

    @ApiModelProperty(value = "业务主键-字符数组")
    @JsonProperty
    public List<String> bizKeysToString() {
        return Optional.ofNullable(super.getInternalBizKey()).map(row -> row.split(","))
                .map(Arrays::asList).orElse(Collections.emptyList());
    }

    @ApiModelProperty(value = "业务主键-整形数组")
    @JsonProperty
    public List<Long> bizKeysToLong() {
        return bizKeysToString().stream().map(Long::valueOf).collect(Collectors.toList());
    }

    @ApiModelProperty(value = "应用角色")
    private String roleIds;

    @ApiModelProperty(value = "指定用户")
    private String userIds;

    @ApiModelProperty(value = "审批状态")
    private String bpmnStatus;

    @ApiModelProperty(value = "流程实例id")
    private String procInstId;

    @ApiModelProperty(value = "错误原因")
    private String errorMsg;

    @ApiModelProperty(value = "敏感词列表")
    private Set<String> sensitiveWords;
}
