/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.config.BpmnUdcConfig;
import com.elitesland.cbpl.bpmn.service.BpmnCommonService;
import com.elitesland.cbpl.bpmn.udc.BpmnEnable;
import com.elitesland.cbpl.bpmn.udc.BpmnEnv;
import com.elitesland.cbpl.bpmn.udc.BpmnExternal;
import com.elitesland.cbpl.bpmn.udc.BpmnInternal;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCommonRespVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BpmnCommonServiceImpl
implements BpmnCommonService {
    private static final Logger logger = LoggerFactory.getLogger(BpmnCommonServiceImpl.class);
    private final BpmnUdcConfig udcConfig;

    @Override
    public List<BpmnCommonRespVO> queryCommonUdc(String type) {
        ArrayList<BpmnCommonRespVO> respVOList = new ArrayList<BpmnCommonRespVO>();
        if (StringUtils.isNotEmpty((String)type)) {
            switch (type) {
                case "env": {
                    BpmnEnv[] envs = BpmnEnv.values();
                    Stream.of(envs).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    this.excludeConfig(this.udcConfig.getEnv(), respVOList);
                    break;
                }
                case "external": {
                    BpmnExternal[] externals = BpmnExternal.values();
                    Stream.of(externals).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    this.excludeConfig(this.udcConfig.getExternal(), respVOList);
                    break;
                }
                case "internal": {
                    BpmnInternal[] internals = BpmnInternal.values();
                    Stream.of(internals).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    this.excludeConfig(this.udcConfig.getInternal(), respVOList);
                    break;
                }
                case "enable": {
                    BpmnEnable[] enables = BpmnEnable.values();
                    Stream.of(enables).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode().toString(), env.getDesc())));
                    break;
                }
                case "module": {
                    BpmnModule[] modules = BpmnModule.values();
                    Stream.of(modules).forEach(env -> respVOList.add(new BpmnCommonRespVO(env.getCode(), env.getDesc())));
                    break;
                }
            }
        }
        return respVOList;
    }

    private void excludeConfig(String envExclude, List<BpmnCommonRespVO> respVOList) {
        if (StringUtils.isNotEmpty((String)envExclude)) {
            List<String> split = Arrays.asList(envExclude.split(","));
            respVOList.removeAll(respVOList.stream().filter(resp -> split.contains(resp.getCode())).collect(Collectors.toList()));
        }
    }

    public BpmnCommonServiceImpl(BpmnUdcConfig udcConfig) {
        this.udcConfig = udcConfig;
    }
}

