/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.provider.general;

import com.elitesland.cbpl.bpmn.convert.BpmnCfgConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnCommentDO;
import com.elitesland.cbpl.bpmn.provider.LexiconApprovalProvider;
import com.elitesland.cbpl.bpmn.service.BpmnCommentService;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnInstStatus;
import com.elitesland.cbpl.bpmn.udc.BpmnOptType;
import com.elitesland.cbpl.bpmn.util.SensitiveWordUtils;
import com.elitesland.cbpl.bpmn.vo.param.SensitiveWordParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class LexiconApprGeneralProvider
implements LexiconApprovalProvider {
    private static final Logger logger = LoggerFactory.getLogger(LexiconApprGeneralProvider.class);
    private static final String AUTO_USER = "SYSTEM";
    private static final String AUTO_ROLE = "SYSTEM";
    private final BpmnInstanceService bpmnInstanceService;
    private final BpmnCommentService bpmnCommentService;
    private final SensitiveWordUtils sensitiveWordUtils;

    @Override
    public BpmnResultRespVO startProcess(BpmnCfgRespVO bpmnCfgRespVO, String bizKey, SensitiveWordParamVO wordParamVO) {
        boolean containsFlag = this.sensitiveWordUtils.isContainsSensitiveWord(wordParamVO);
        BpmnResultRespVO resultVO = BpmnCfgConvert.INSTANCE.cfgToResultVO(bpmnCfgRespVO);
        if (containsFlag) {
            Set<String> sensitiveWord = this.sensitiveWordUtils.getSensitiveWord(wordParamVO);
            resultVO.setSensitiveWords(sensitiveWord);
        }
        resultVO.setUserIds("SYSTEM");
        resultVO.setRoleIds("SYSTEM");
        resultVO.setBpmnStatus(!containsFlag ? BpmnInstStatus.APPROVED.getCode() : BpmnInstStatus.REJECTED.getCode());
        Long bpmnInstId = this.bpmnInstanceService.insert(resultVO, bizKey);
        resultVO.setBpmnInstId(bpmnInstId);
        BpmnCommentDO bpmnCommentDO = new BpmnCommentDO();
        bpmnCommentDO.setBpmnInstId(resultVO.getBpmnInstId());
        bpmnCommentDO.setUserId(IamUserUtil.currentUserId());
        bpmnCommentDO.setType(!containsFlag ? BpmnOptType.AGREE.getCode() : BpmnOptType.REJECT.getCode());
        bpmnCommentDO.setMessage(IamUserUtil.currentUserName() + "\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279\u5b8c\u6210");
        this.bpmnCommentService.insert(bpmnCommentDO);
        return resultVO;
    }

    public LexiconApprGeneralProvider(BpmnInstanceService bpmnInstanceService, BpmnCommentService bpmnCommentService, SensitiveWordUtils sensitiveWordUtils) {
        this.bpmnInstanceService = bpmnInstanceService;
        this.bpmnCommentService = bpmnCommentService;
        this.sensitiveWordUtils = sensitiveWordUtils;
    }
}

