package com.elitesland.cbpl.page.service;

import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.resp.PageConfigView;
import com.elitesland.cbpl.page.vo.save.PageConfigSaveParam;
import com.elitesland.yst.common.base.PagingVO;

import java.util.List;

/**
 * @author andy.zhao1
 * @since 2023/2/20
 */
public interface PageConfigService {

    /**
     * 1.保存页面配置
     *
     * @param saveParam 保存参数
     * @return 主键Id
     */
    Long pageSave(PageConfigSaveParam saveParam);

    /**
     * 2.分页查询页面配置
     *
     * @param queryParam 查询参数
     * @return 页面配置信息
     */
    PagingVO<PageConfigView> pageSearch(PageConfigQueryParam queryParam);

    /**
     * 3.根据id批量删除页面配置信息
     *
     * @param ids 页面配置id
     */
    void deleteFlagBatchs(List<Long> ids);

    /**
     * 4.根据id查询页面配置详情
     *
     * @param id id
     * @return 页面配置详情
     */
    PageConfigView getById(Long id);
}
