package com.elitesland.cbpl.page.controller;

import com.elitesland.cbpl.page.service.PageConfigService;
import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.save.PageConfigSaveParam;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2022/06/01
 */
@Slf4j
@Api(tags = "页面管理")
@RestController
@RequestMapping(value = "/page", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class PageConfigController {

    private final PageConfigService pageConfigService;

    @ApiOperation(value = "页面管理 - 新增")
    @PostMapping("/save")
    public ApiResult<?> pageSave(@RequestBody PageConfigSaveParam saveParam) {
        try {
            logger.info("[CBPL-PAGE] page save, saveParam={}", saveParam);
            return ApiResult.ok(pageConfigService.pageSave(saveParam));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "页面管理 - 分页查询")
    @PostMapping("/search")
    public ApiResult<PagingVO<?>> pageSearch(@RequestBody PageConfigQueryParam queryParam) {
        try {
            logger.info("[CBPL-PAGE] page search, queryParam={}", queryParam);
            return ApiResult.ok(pageConfigService.pageSearch(queryParam));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "页面管理 - 批量逻辑删除")
    @DeleteMapping("/deleteFlagBatchs")
    public ApiResult<?> deleteFlagBatchs(@RequestBody List<Long> ids) {
        try {
            logger.info("[CBPL-PAGE] page delete by ids, ids={}", ids);
            pageConfigService.deleteFlagBatchs(ids);
            return ApiResult.ok();
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "页面管理 - 查询明细")
    @GetMapping("/getById/{id}")
    public ApiResult<?> getById(@PathVariable Long id) {
        try {
            logger.info("[CBPL-PAGE] page get by id, id={}", id);
            return ApiResult.ok(pageConfigService.getById(id));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }
}
