package com.elitesland.cbpl.page.entity;

import com.elitesland.yst.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author andy.zhao1
 * @since 2023/2/21
 */
@Entity
@Table(name = "cbpl_page_config")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_page_config", comment = "页面配置")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_page_config", description = "页面配置")
public class PageConfigDO extends BaseModel implements Serializable {

    @Comment(value = "页面编码")
    @Column()
    private String pageCode;

    @Comment(value = "页面名称")
    @Column()
    private String pageName;

    @Comment(value = "页面标题")
    @Column()
    private String pageTitle;

    @Comment(value = "页面详情")
    @Column()
    private String pageBody;
}
