package com.elitesland.cbpl.page.repo;

import com.elitesland.cbpl.page.entity.QPageConfigDO;
import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.resp.PageConfigView;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author andy.zhao1
 * @since 2023/2/20
 */
@Component
@RequiredArgsConstructor
public class PageConfigRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPageConfigDO INSTANCE = QPageConfigDO.pageConfigDO;

    public JPAQuery<PageConfigView> select() {
        return jpaQueryFactory.select(Projections.bean(PageConfigView.class,
                INSTANCE.id,
                INSTANCE.pageCode,
                INSTANCE.pageTitle,
                INSTANCE.pageName,
                INSTANCE.tenantId,
                INSTANCE.remark,
                INSTANCE.createUserId,
                INSTANCE.creator,
                INSTANCE.createTime,
                INSTANCE.modifyUserId,
                INSTANCE.updater,
                INSTANCE.modifyTime,
                INSTANCE.deleteFlag,
                INSTANCE.auditDataVersion,
                INSTANCE.secBuId,
                INSTANCE.secUserId,
                INSTANCE.secOuId
        )).from(INSTANCE);
    }

    public Long countContractTmpl(PageConfigQueryParam queryParam) {
        return this.select().where(this.where(queryParam)).fetchCount();
    }

    private Predicate where(PageConfigQueryParam queryParam) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        return predicate;
    }

    public List<PageConfigView> search(PageConfigQueryParam queryParam) {
        var jpaQuery = this.select();
        queryParam.fillOrders(jpaQuery, INSTANCE);
        queryParam.setPaging(jpaQuery);
        return jpaQuery.where(this.where(queryParam)).fetch();
    }
}
