package com.elitesland.cbpl.page.service.impl;

import com.elitesland.cbpl.page.entity.PageConfigDO;
import com.elitesland.cbpl.page.repo.PageConfigRepo;
import com.elitesland.cbpl.page.repo.PageConfigRepoProc;
import com.elitesland.cbpl.page.service.PageConfigService;
import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.resp.PageConfigView;
import com.elitesland.cbpl.page.vo.save.PageConfigSaveParam;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * @author andy.zhao1
 * @since 2023/2/20
 */
@Slf4j
@Service
@AllArgsConstructor
public class PageConfigServiceImpl implements PageConfigService {

    private final PageConfigRepo pageConfigRepo;
    private final PageConfigRepoProc pageConfigRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long pageSave(PageConfigSaveParam saveParam) {
        logger.info("[CBPL-PAGE] page save execute");
        PageConfigDO pageConfigDO = new PageConfigDO();
        BeanUtils.copyProperties(saveParam, pageConfigDO);
        PageConfigDO save = pageConfigRepo.save(pageConfigDO);
        return save.getId();
    }

    @Override
    public PagingVO<PageConfigView> pageSearch(PageConfigQueryParam queryParam) {
        logger.info("[CBPL-PAGE] page search execute");
        var total = pageConfigRepoProc.countContractTmpl(queryParam);
        var search = pageConfigRepoProc.search(queryParam);
        return total > 0 ? PagingVO.<PageConfigView>builder()
                .total(total)
                .records(search)
                .build() : new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteFlagBatchs(List<Long> ids) {
        logger.info("[CBPL-PAGE] page delete by ids execute");
        var pageConfigs = ids.stream().map(pageConfigRepo::findById).toList();
        pageConfigs.stream().filter(Optional::isPresent).forEach(pageConfig -> {
            pageConfig.get().setDeleteFlag(1);
            pageConfigRepo.save(pageConfig.get());
        });
    }

    @Override
    public PageConfigView getById(Long id) {
        logger.info("[CBPL-PAGE] page get by id execute");
        Optional<PageConfigDO> pageConfig = pageConfigRepo.findById(id);
        if (pageConfig.isEmpty()) {
            throw new BusinessException("未找到该页面配置信息，id" + id);
        }
        PageConfigView result = new PageConfigView();
        BeanUtils.copyProperties(pageConfig.get(), result);
        return result;
    }
}
