package com.elitesland.cbpl.page.vo.resp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author andy.zhao1
 * @since 2023/2/20
 */
@Data
public class PageConfigView implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("页面编码")
    private String pageCode;

    @ApiModelProperty(value = "页面名称")
    private String pageName;

    @ApiModelProperty(value = "页面标题")
    private String pageTitle;

    @ApiModelProperty(value = "页面详情")
    private String pageBody;

    /**
     * 记录创建者ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    /**
     * 记录创建者
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建者")
    private String creator;

    /**
     * 记录创建时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    /**
     * 记录最后更新者
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除，0：未删除，1：已删除
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    /**
     * 锁版本
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    /**
     * sec_bu_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_bu_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    /**
     * sec_user_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_user_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    /**
     * sec_ou_id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "sec_ou_id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 租户ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;

    /**
     * 备注
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "备注")
    private String remark;
}
