/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.page.controller;

import com.elitesland.cbpl.page.service.PageConfigService;
import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.save.PageConfigSaveParam;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9875\u9762\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/page"}, produces={"application/json"})
public class PageConfigController {
    private static final Logger logger = LoggerFactory.getLogger(PageConfigController.class);
    private final PageConfigService pageConfigService;

    @ApiOperation(value="\u9875\u9762\u7ba1\u7406 - \u65b0\u589e")
    @PostMapping(value={"/save"})
    public ApiResult<?> pageSave(@RequestBody PageConfigSaveParam saveParam) {
        try {
            logger.info("[CBPL-PAGE] page save, saveParam={}", (Object)saveParam);
            return ApiResult.ok((Object)this.pageConfigService.pageSave(saveParam));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9875\u9762\u7ba1\u7406 - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/search"})
    public ApiResult<PagingVO<?>> pageSearch(@RequestBody PageConfigQueryParam queryParam) {
        try {
            logger.info("[CBPL-PAGE] page search, queryParam={}", (Object)queryParam);
            return ApiResult.ok(this.pageConfigService.pageSearch(queryParam));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9875\u9762\u7ba1\u7406 - \u6279\u91cf\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/deleteFlagBatchs"})
    public ApiResult<?> deleteFlagBatchs(@RequestBody List<Long> ids) {
        try {
            logger.info("[CBPL-PAGE] page delete by ids, ids={}", ids);
            this.pageConfigService.deleteFlagBatchs(ids);
            return ApiResult.ok();
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9875\u9762\u7ba1\u7406 - \u67e5\u8be2\u660e\u7ec6")
    @GetMapping(value={"/getById/{id}"})
    public ApiResult<?> getById(@PathVariable Long id) {
        try {
            logger.info("[CBPL-PAGE] page get by id, id={}", (Object)id);
            return ApiResult.ok((Object)this.pageConfigService.getById(id));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public PageConfigController(PageConfigService pageConfigService) {
        this.pageConfigService = pageConfigService;
    }
}

