/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.page.service.impl;

import com.elitesland.cbpl.page.entity.PageConfigDO;
import com.elitesland.cbpl.page.repo.PageConfigRepo;
import com.elitesland.cbpl.page.repo.PageConfigRepoProc;
import com.elitesland.cbpl.page.service.PageConfigService;
import com.elitesland.cbpl.page.vo.param.PageConfigQueryParam;
import com.elitesland.cbpl.page.vo.resp.PageConfigView;
import com.elitesland.cbpl.page.vo.save.PageConfigSaveParam;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PageConfigServiceImpl
implements PageConfigService {
    private static final Logger logger = LoggerFactory.getLogger(PageConfigServiceImpl.class);
    private final PageConfigRepo pageConfigRepo;
    private final PageConfigRepoProc pageConfigRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long pageSave(PageConfigSaveParam saveParam) {
        logger.info("[CBPL-PAGE] page save execute");
        PageConfigDO pageConfigDO = new PageConfigDO();
        BeanUtils.copyProperties((Object)saveParam, (Object)pageConfigDO);
        PageConfigDO save = (PageConfigDO)this.pageConfigRepo.save(pageConfigDO);
        return save.getId();
    }

    @Override
    public PagingVO<PageConfigView> pageSearch(PageConfigQueryParam queryParam) {
        logger.info("[CBPL-PAGE] page search execute");
        Long total = this.pageConfigRepoProc.countContractTmpl(queryParam);
        List<PageConfigView> search = this.pageConfigRepoProc.search(queryParam);
        return total > 0L ? PagingVO.builder().total(total).records(search).build() : new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteFlagBatchs(List<Long> ids) {
        logger.info("[CBPL-PAGE] page delete by ids execute");
        List<Optional> pageConfigs = ids.stream().map(arg_0 -> ((PageConfigRepo)this.pageConfigRepo).findById(arg_0)).toList();
        pageConfigs.stream().filter(Optional::isPresent).forEach(pageConfig -> {
            ((PageConfigDO)pageConfig.get()).setDeleteFlag(1);
            this.pageConfigRepo.save((PageConfigDO)pageConfig.get());
        });
    }

    @Override
    public PageConfigView getById(Long id) {
        logger.info("[CBPL-PAGE] page get by id execute");
        Optional pageConfig = this.pageConfigRepo.findById(id);
        if (pageConfig.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u9875\u9762\u914d\u7f6e\u4fe1\u606f\uff0cid" + id);
        }
        PageConfigView result = new PageConfigView();
        BeanUtils.copyProperties(pageConfig.get(), (Object)result);
        return result;
    }

    public PageConfigServiceImpl(PageConfigRepo pageConfigRepo, PageConfigRepoProc pageConfigRepoProc) {
        this.pageConfigRepo = pageConfigRepo;
        this.pageConfigRepoProc = pageConfigRepoProc;
    }
}

