CREATE TABLE IF NOT EXISTS `cbpl_page_config` (
    `id` BIGINT(20) NOT NULL COMMENT '记录唯一ID',
    `page_code` VARCHAR(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面编码',
    `page_name` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面名称',
    `page_title` VARCHAR(255)  CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面标题',
    `page_body` mediumtext NULL DEFAULT NULL COMMENT '页面内容',

    `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
    `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '页面配置表';