/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.kumiho.aop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.elastic.repository.ElasticRepository;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.kumiho.annotation.KumihoCommand;
import com.elitesland.cbpl.kumiho.handler.KumihoDataHandler;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import com.elitesland.cbpl.util.StringTools;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class KumihoCommandAop {
    private static final Logger logger = LoggerFactory.getLogger(KumihoCommandAop.class);
    private static final String TENANT_SHORT_PREFIX = "_tenant_";
    @Autowired
    private ElasticRepository elasticRepository;

    @Pointcut(value="@annotation(com.elitesland.cbpl.kumiho.annotation.KumihoCommand)")
    public void commandCut() {
    }

    @AfterReturning(value="commandCut()", returning="retObj")
    public void after(JoinPoint point, Object retObj) {
        Class<? extends KumihoDataHandler> clazz = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(KumihoCommand.class).value();
        KumihoDataHandler handler = (KumihoDataHandler)ApplicationContextGetBeanHelper.getBean((String)clazz.getName());
        if (ObjectUtil.isNull((Object)handler)) {
            throw new RuntimeException("[KUMIHO] " + clazz.getName() + "\uff1a\u672a\u627e\u5230\u7c7b\u5b9e\u4f8b");
        }
        List data = handler.queryData(point.getArgs(), retObj);
        String tenantId = IamUserUtil.currentTenantIdStr();
        logger.debug("[KUMIHO] \u79df\u6237({}), \u540c\u6b65\u7684\u5b9e\u4f53\u7c7b({}), \u5f85\u540c\u6b65\u6570\u636e\uff1a{}", new Object[]{tenantId, clazz.getName(), data});
        this.dataAsync(data, tenantId);
    }

    private void dataAsync(List<?> data, String tenantId) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        Class<?> clazz = data.get(0).getClass();
        String indexName = StringTools.humpToUnderline((String)clazz.getSimpleName()) + TENANT_SHORT_PREFIX + tenantId;
        this.elasticRepository.batchInsert(data, indexName);
    }
}

