/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.kumiho.aop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.elastic.repository.ElasticRepository;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.kumiho.annotation.Kumiho;
import com.elitesland.cbpl.kumiho.handler.KumihoHandler;
import com.elitesland.cbpl.kumiho.util.KumihoEsUtil;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class KumihoCommandBus {
    private static final Logger logger = LoggerFactory.getLogger(KumihoCommandBus.class);
    @Autowired
    private ElasticRepository elasticRepository;

    @Pointcut(value="@annotation(com.elitesland.cbpl.kumiho.annotation.Kumiho)")
    public void command() {
    }

    @AfterReturning(value="command()", returning="retObj")
    public void after(JoinPoint point, Object retObj) {
        Class<? extends KumihoHandler>[] clazzArr;
        for (Class<? extends KumihoHandler> clazz : clazzArr = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(Kumiho.class).value()) {
            KumihoHandler handler = (KumihoHandler)ApplicationContextGetBeanHelper.getBean((String)clazz.getName());
            if (ObjectUtil.isNull((Object)handler)) {
                throw new RuntimeException("[KUMIHO] " + clazz.getName() + "\uff1a\u672a\u627e\u5230\u7c7b\u5b9e\u4f8b");
            }
            List data = handler.aggregate(point.getArgs(), retObj);
            String tenantId = IamUserUtil.currentTenantIdStr();
            logger.debug("[KUMIHO] \u79df\u6237({}), \u540c\u6b65\u7684\u5b9e\u4f53\u7c7b({}), \u5f85\u540c\u6b65\u6570\u636e\uff1a{}", new Object[]{tenantId, clazz.getName(), data});
            this.dataAsync(data);
        }
    }

    private void dataAsync(List<?> data) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        Class<?> clazz = data.get(0).getClass();
        this.elasticRepository.batchInsert(data, KumihoEsUtil.indexNameByClz(clazz));
    }
}

