/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.service;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.rosefinch.entity.RosefinchDetailDO;
import com.elitesland.cbpl.rosefinch.entity.RosefinchLogDO;
import com.elitesland.cbpl.rosefinch.service.RosefinchService;
import com.elitesland.cbpl.rosefinch.udc.LogStatusEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class RosefinchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchExecutor.class);
    @Autowired
    private TaskExecutor taskExecutor;
    private final RosefinchService rosefinchService;

    public <T> void runAsync(String asyncType, List<T> source, Function<T, String> func) {
        RosefinchLogDO headLog = this.rosefinchService.init(asyncType, source.size());
        headLog.setTotalCount(source.size());
        ArrayList<RosefinchDetailDO> detailLogList = new ArrayList<RosefinchDetailDO>();
        if (CollUtil.isEmpty(source)) {
            headLog.setEndTime(LocalDateTime.now());
            this.rosefinchService.save(headLog, detailLogList);
            return;
        }
        AtomicInteger successCnt = new AtomicInteger();
        AtomicInteger failCnt = new AtomicInteger();
        CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> {
            for (int i = 0; i < source.size(); ++i) {
                RosefinchDetailDO detailDO = new RosefinchDetailDO();
                detailDO.setLineNo(i + 1);
                detailDO.setStartTime(LocalDateTime.now());
                try {
                    detailDO.setLogStatus("S");
                    detailDO.setErrorMsg((String)func.apply(source.get(i)));
                    detailLogList.add(detailDO);
                    successCnt.getAndIncrement();
                }
                catch (Exception e) {
                    detailDO.setLogStatus("E");
                    detailDO.setErrorMsg(e.getMessage());
                    detailLogList.add(detailDO);
                    failCnt.getAndIncrement();
                }
                detailDO.setEndTime(LocalDateTime.now());
            }
            headLog.setSuccessCount(successCnt.get());
            headLog.setFailCount(failCnt.get());
        }, (Executor)this.taskExecutor);
        cf.thenAccept(result -> {
            headLog.setLogStatus(LogStatusEnum.TRUE.getValue());
            headLog.setEndTime(LocalDateTime.now());
            this.rosefinchService.save(headLog, detailLogList);
        });
    }

    public RosefinchExecutor(RosefinchService rosefinchService) {
        this.rosefinchService = rosefinchService;
    }
}

