-- ----------------------------
-- Oracle Table structure for CBPL_ROSEFINCH_DETAIL
-- ----------------------------
CREATE TABLE CBPL_ROSEFINCH_DETAIL
(
  ID NUMBER(20, 0) NOT NULL
, OU_ID NUMBER(20, 0)
, ORG_ID NUMBER(20, 0)
, LINE_NO NUMBER(20, 0)
, MAS_ID NUMBER(20, 0) NOT NULL
, LOG_STATUS NVARCHAR2(16)
, ERROR_MSG NVARCHAR2(1000)
, TENANT_ID NUMBER(20, 0)
, REMARK NVARCHAR2(255)
, CREATE_USER_ID NUMBER(20, 0)
, CREATOR NVARCHAR2(255)
, CREATE_TIME DATE
, MODIFY_USER_ID NUMBER(20, 0)
, UPDATER NVARCHAR2(255)
, MODIFY_TIME DATE
, DELETE_FLAG NUMBER(1, 0)
, AUDIT_DATA_VERSION NUMBER(11, 0)
, SEC_BU_ID NUMBER(20, 0)
, SEC_USER_ID NUMBER(20, 0)
, SEC_OU_ID NUMBER(20, 0)

, CONSTRAINT PK_CBPL_ROSEFINCH_DETAIL_ID PRIMARY KEY (ID)
);

COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.ID IS '唯一标识';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.OU_ID IS '公司ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.ORG_ID IS '组织ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.LINE_NO IS '行号';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.MAS_ID IS '主表id';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.LOG_STATUS IS '日志行状态';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.ERROR_MSG IS '错误信息';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.TENANT_ID IS '租户ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.REMARK IS '备注';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.CREATE_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.CREATOR IS '记录创建者';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.SEC_BU_ID IS '数据归属组织id';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.SEC_USER_ID IS '数据归属雇员id';
COMMENT ON COLUMN CBPL_ROSEFINCH_DETAIL.SEC_OU_ID IS '数据归属公司id';
COMMENT ON TABLE CBPL_ROSEFINCH_DETAIL IS '批处理日志明细';