package com.elitesland.cbpl.kumiho.handler;

import cn.hutool.core.util.ClassUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/01/31
 */
@Slf4j
@Component
public class KumihoDefaultHandler extends KumihoHandler {

    @SuppressWarnings("unchecked")
    @Override
    public List<Object> aggregate(Object[] args, Object result) {
        Class<?> clazz;
        // 空数据
        if (result == null) {
            logger.info("[KUMIHO] aggregate data empty.");
            return Collections.emptyList();
        }

        // 基本类型
        if (ClassUtil.isSimpleValueType(clazz = result.getClass())) {
            logger.info("[KUMIHO] aggregate class is basic type.");
            return Collections.emptyList();
        }

        // 集合
        if (result instanceof Collection<?>) {
            logger.trace("[KUMIHO] aggregate class is collection.");
            return (List<Object>) result;
        }

        // JDK中定义的类或接口
        if (ClassUtil.isJdkClass(clazz)) {
            logger.trace("[KUMIHO] aggregate class in JDK.");
            return Collections.emptyList();
        }

        // 标准类
        if (ClassUtil.isNormalClass(clazz)) {
            logger.trace("[KUMIHO] aggregate class is normal.");
            return List.of(result);
        }

        logger.info("[KUMIHO] aggregate class is unrecognized.");
        return Collections.emptyList();
    }
}
