package com.elitesland.cbpl.kumiho.handler;

import com.elitesland.cbpl.kumiho.domain.KumihoDoc;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/02/01
 */
public abstract class KumihoHandler<T extends KumihoDoc> implements KumihoAggregate<T> {

    /**
     * 单条数据同步 - 新增或修改
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    T restoreEvent(String param) {
        // todo something
        return null;
    }

    /**
     * 单条数据同步 - 覆盖更新
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    T restoreOverrideEvent(String param) {
        // todo something
        return null;
    }

    /**
     * 批量数据同步 - 新增或修改
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    List<T> restoreBatchEvent(String param) {
        // todo something
        return null;
    }

    /**
     * 批量数据同步 - 覆盖更新
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    List<T> restoreOverrideBatchEvent(String param) {
        // todo something
        return null;
    }
}
