package com.elitesland.cbpl.kumiho.service;

import com.elitesland.cbpl.elastic.repository.ElasticRepository;
import com.elitesland.cbpl.kumiho.util.KumihoEsUtil;
import com.elitesland.yst.common.base.PagingVO;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/10/13
 */
@Slf4j
@Service
public class KumihoEsService {

    private static final int KUMIHO_ES_PAGE = 0;
    private static final int KUMIHO_ES_SIZE = 20;

    @Autowired
    private ElasticRepository elasticRepository;

    @SuppressWarnings("unchecked")
    public <T> List<T> queryList(T query) {
        Class<T> clazz = (Class<T>) query.getClass();
        String indexName = KumihoEsUtil.indexNameByClz(clazz);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        // TODO with query column
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder()
                .withQuery(boolQueryBuilder)
                .build();
        return elasticRepository.queryList(indexName, clazz, nativeSearchQuery);
    }

    public <T extends Serializable> PagingVO<T> queryPaging(T query) {
        return queryPaging(query, KUMIHO_ES_PAGE, KUMIHO_ES_SIZE);
    }

    /**
     * 分页接口
     *
     * @param query 查询条件
     * @param <T>   索引对象类
     * @return 分页结果
     */
    @SuppressWarnings("unchecked")
    private <T extends Serializable> PagingVO<T> queryPaging(T query, int page, int size) {
        Class<T> clazz = (Class<T>) query.getClass();
        String indexName = KumihoEsUtil.indexNameByClz(clazz);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        // TODO with query column
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder()
                .withQuery(boolQueryBuilder)
                .withPageable(PageRequest.of(page, size))
                .build();
        return elasticRepository.queryPaging(indexName, clazz, nativeSearchQuery);
    }
}
