package com.elitesland.cbpl.kumiho.util;

import com.elitesland.cbpl.kumiho.annotation.Kumiho;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.function.Function;

/**
 * @author eric.hao
 * @since 2023/01/30
 */
@Component
public class KumihoCommand {

    private static KumihoCommand kumihoCommand;

    @Autowired
    public void setKumihoCommand(KumihoCommand kumihoCommand) {
        KumihoCommand.kumihoCommand = kumihoCommand;
    }

    /**
     * 异步执行 TODO
     */
    public static <T, R> R send(T param, Function<T, R> func) {
        return kumihoCommand.execute(param, func);
    }

    /**
     * 同步执行，会等待结果返回 TODO
     */
    public static <T, R> R sendAndWait(T param, Function<T, R> func) {
        return kumihoCommand.execute(param, func);
    }

    /**
     * 执行命令处理器
     */
    @Kumiho
    public <T, R> R execute(T param, Function<T, R> func) {
        return func.apply(param);
    }
}
