package com.elitesland.cbpl.rosefinch.controller;

import com.elitesland.cbpl.rosefinch.service.RosefinchService;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchDetailPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchDetailRespVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchListRespVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Slf4j
@Api(tags = "异步批处理")
@ApiSupport(author = "eric.hao", order = 1)
@RestController
@RequestMapping(value = "/rosefinch", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class RosefinchController {

    private final RosefinchService rosefinchService;

    @ApiOperation(value = "异步批处理 - 分页查询")
    @PostMapping(value = "/list")
    public ApiResult<PagingVO<RosefinchListRespVO>> list(@RequestBody RosefinchPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-ROSEFINCH] page list, param={}", paramVO);
            return ApiResult.ok(rosefinchService.rosefinchPageBy(paramVO));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "异步批处理 - 明细查询")
    @PostMapping("/detail")
    public ApiResult<PagingVO<RosefinchDetailRespVO>> detail(@RequestBody @Validated RosefinchDetailPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-ROSEFINCH] query detail param={}", paramVO);
            return ApiResult.ok(rosefinchService.rosefinchDetails(paramVO));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }
}
